
from gurobipy import *

# Create a new model
m = Model("Bus_Ticket_Sales")

# Define the decision variables
A = m.addVar(name='Adult_Tickets', lb=0, ub=GRB.INFINITY, vtype=GRB.INTEGER)
C = m.addVar(name='Children_Tickets', lb=0, ub=GRB.INFINITY, vtype=GRB.INTEGER)

# Set the objective function to maximize profit
m.setObjective(3*A + C, GRB.MAXIMIZE)

# Add constraints
m.addConstr(A + C <= 80, name='Total_Capacity')
m.addConstr(C >= 15, name='Children_Tickets_Minimum')
m.addConstr(A >= 3*C, name='Adult_vs_Children_Tickets')

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print('Optimal solution found:')
    print(f'Adult Tickets: {A.x}')
    print(f'Children Tickets: {C.x}')
    print(f'Total Profit: {3*A.x + C.x}')
else:
    print('No optimal solution found')

