
import gurobi

def solve_ticket_problem():
    # Create a new model
    m = gurobi.Model()

    # Define variables
    A = m.addVar(name="Adult_Tickets", lb=0, ub=None)
    C = m.addVar(name="Children_Tickets", lb=0, ub=None)

    # Objective function: Maximize profit
    m.setObjective(3*A + C, gurobi.GRB.MAXIMIZE)

    # Constraints
    m.addConstr(A + C <= 80, name="Bus_Capacity")
    m.addConstr(C >= 15, name="Children_Tickets_Reservation")
    m.addConstr(A >= 3*C, name="Adult_vs_Children_Tickets_Ratio")

    # Solve the problem
    m.optimize()

    # Check if the model is optimized
    if m.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution: Adult Tickets = {A.varValue}, Children's Tickets = {C.varValue}")
        print(f"Max Profit: ${3*A.varValue + C.varValue}")
    else:
        print("The model is infeasible")

solve_ticket_problem()
