
import gurobipy as gp

# Create a new model
m = gp.Model("investment_optimization")

# Create variables
biotech = m.addVar(lb=0, name="biotech")
food = m.addVar(lb=0, name="food")
finance = m.addVar(lb=0, name="finance")
healthcare = m.addVar(lb=0, name="healthcare")

# Set objective function
m.setObjective(0.04 * biotech + 0.06 * food + 0.08 * finance + 0.10 * healthcare, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(biotech + food + finance + healthcare == 1000000, "total_investment")
m.addConstr(healthcare <= biotech, "healthcare_biotech_constraint")
m.addConstr(food <= finance, "food_finance_constraint")
m.addConstr(healthcare <= 0.30 * 1000000, "healthcare_investment_limit")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Biotech: ${biotech.x:.2f}")
    print(f"Food: ${food.x:.2f}")
    print(f"Finance: ${finance.x:.2f}")
    print(f"Healthcare: ${healthcare.x:.2f}")
    print(f"Total Return: ${(0.04 * biotech.x + 0.06 * food.x + 0.08 * finance.x + 0.10 * healthcare.x):.2f}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

