
from gurobipy import *

# Create a new model
m = Model("Investment_Optimization")

# Define the variables
B = m.addVar(lb=0, name="Biotech")
F = m.addVar(lb=0, name="Food")
FI = m.addVar(lb=0, name="Finance")
H = m.addVar(lb=0, name="Healthcare")

# Set the objective function to maximize
m.setObjective(0.04*B + 0.06*F + 0.08*FI + 0.10*H, GRB.MAXIMIZE)

# Add constraints
m.addConstr(B + F + FI + H <= 1000000, "Total_Investment")
m.addConstr(H <= B, "Healthcare_Biotech_Constraint")
m.addConstr(F <= FI, "Food_Finance_Constraint")
m.addConstr(H <= 300000, "Max_Healthcare_Investment")

# Optimize the model
m.optimize()

# Print the results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print("Objective:", m.objVal)
