
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    B = model.addVar(name="Biotech", lb=0)
    F = model.addVar(name="Food", lb=0)
    FN = model.addVar(name="Finance", lb=0)
    H = model.addVar(name="HealthCare", lb=0)

    # Objective function: maximize return on investment
    model.setObjective(0.04 * B + 0.06 * F + 0.08 * FN + 0.10 * H, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(B + F + FN + H <= 1000000, name="Total_Investment")
    model.addConstr(H <= B, name="HealthCare_vs_Biotech")
    model.addConstr(F <= FN, name="Food_vs_Finance")
    model.addConstr(H <= 300000, name="HealthCare_Limit")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Biotech: ${B.varValue}")
        print(f"Food: ${F.varValue}")
        print(f"Finance: ${FN.varValue}")
        print(f"Health Care: ${H.varValue}")
        print(f"Max Return: ${model.objVal}")
    else:
        print("No optimal solution found.")

solve_investment_problem()
