
import gurobipy as gp

# Create a new model
model = gp.Model("LeatherShop")

# Create decision variables
w = model.addVar(vtype=gp.GRB.CONTINUOUS, name="wallets") # wallets
p = model.addVar(vtype=gp.GRB.CONTINUOUS, name="purses") # purses


# Set objective function
model.setObjective(50*w + 100*p, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(10*w + 15*p <= 500, "cutting_time")
model.addConstr(20*w + 30*p <= 600, "stitching_time")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"  Wallets: {w.x}")
    print(f"  Purses: {p.x}")
    print(f"  Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

