
from gurobipy import *

# Create a new model
m = Model("Leather_Shop")

# Define the decision variables
W = m.addVar(lb=0, vtype=GRB.INTEGER, name="Wallets")
P = m.addVar(lb=0, vtype=GRB.INTEGER, name="Purses")

# Set the objective function to maximize profit
m.setObjective(50*W + 100*P, GRB.MAXIMIZE)

# Add constraints for cutting and stitching time
m.addConstr(10*W + 15*P <= 500, name="Cutting_Time")
m.addConstr(20*W + 30*P <= 600, name="Stitching_Time")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: {W.varName} = {W.x}, {P.varName} = {P.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found")
