
import gurobi

# Create a new model
model = gurobi.Model()

# Define the decision variables
w = model.addVar(lb=0, name="wallet")
p = model.addVar(lb=0, name="purse")

# Define the objective function
model.setObjective(50 * w + 100 * p, gurobi.GRB.MAXIMIZE)

# Define the constraints
model.addConstr(10 * w + 15 * p <= 500, name="cutting_time")
model.addConstr(20 * w + 30 * p <= 600, name="stitching_time")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of wallets: {w.varValue}")
    print(f"Number of purses: {p.varValue}")
    print(f"Max profit: {model.objVal}")
else:
    print("No optimal solution found.")
