
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("ToyProduction")

# Create decision variables
x = model.addVar(vtype=GRB.CONTINUOUS, name="plush_toys")  # Plush toys
y = model.addVar(vtype=GRB.CONTINUOUS, name="action_figures") # Action figures

# Set objective function
model.setObjective(4*x + 4.5*y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(20*x + 15*y <= 1200, "assembly_time")
model.addConstr(4*x + 5*y <= 900, "packaging_time")
model.addConstr(x >= 0, "plush_non_neg")
model.addConstr(y >= 0, "action_non_neg")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"  Plush Toys: {x.x}")
    print(f"  Action Figures: {y.x}")
    print(f"  Maximum Profit: ${model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

