
from gurobipy import *

# Create a model
m = Model("Toy_Shop_Optimization")

# Define variables
P = m.addVar(vtype=GRB.CONTINUOUS, name="Plush_Toys", lb=0)
A = m.addVar(vtype=GRB.CONTINUOUS, name="Action_Figures", lb=0)

# Set the objective function
m.setObjective(4*P + 4.5*A, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*P + 15*A <= 1200, "Assembly_Time")
m.addConstr(4*P + 5*A <= 900, "Packaging_Time")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Plush Toys: {P.x}")
    print(f"Action Figures: {A.x}")
    print(f"Max Profit: ${4*P.x + 4.5*A.x:.2f}")
else:
    print("No optimal solution found")
