
import gurobi

def solve_toy_shop_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    P = model.addVar(lb=0, name="Plush_Toys")  # Number of plush toys
    A = model.addVar(lb=0, name="Action_Figures")  # Number of action figures

    # Objective function: Maximize profit
    model.setObjective(4 * P + 4.50 * A, gurobi.GRB.MAXIMIZE)

    # Assembly time constraint
    model.addConstr(20 * P + 15 * A <= 1200, name="Assembly_Time")

    # Packaging time constraint
    model.addConstr(4 * P + 5 * A <= 900, name="Packaging_Time")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found.")
        print(f"Plush Toys: {P.varValue}")
        print(f"Action Figures: {A.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

if __name__ == "__main__":
    solve_toy_shop_problem()
