
import gurobipy as gp

# Create a new model
model = gp.Model("Jewelry_Production")

# Create decision variables
r = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="rings")
n = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="necklaces")

# Set objective function
model.setObjective(50*r + 75*n, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(2*r + 3*n <= 1000, "gold_constraint")
model.addConstr(r >= 3*n, "popularity_constraint")
model.addConstr(n >= 50, "min_necklaces_constraint")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of rings: {r.x}")
    print(f"Number of necklaces: {n.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

