
from gurobipy import *

# Create a new model
m = Model("JewelryProfit")

# Define variables
R = m.addVar(lb=0, vtype=GRB.INTEGER, name="Rings")
N = m.addVar(lb=0, vtype=GRB.INTEGER, name="Necklaces")

# Objective function: Maximize profit
m.setObjective(50*R + 75*N, GRB.MAXIMIZE)

# Constraints
m.addConstr(2*R + 3*N <= 1000, "GoldAvailability")
m.addConstr(R >= 3*N, "PopularityConstraint")
m.addConstr(N >= 50, "MinimumNecklaces")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Rings: {R.x}")
    print(f"Necklaces: {N.x}")
    print(f"Total Profit: ${50*R.x + 75*N.x}")
else:
    print("No optimal solution found")
