
import gurobi

def solve_jeweler_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    R = model.addVar(lb=0, name="Rings")
    N = model.addVar(lb=0, name="Necklaces")

    # Objective function: Maximize profit
    model.setObjective(50*R + 75*N, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(2*R + 3*N <= 1000, name="Gold_Constraint")
    model.addConstr(R >= 3*N, name="Ring_Necklace_Ratio")
    model.addConstr(N >= 50, name="Necklace_Minimum")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: Rings = {R.varValue}, Necklaces = {N.varValue}")
        print(f"Max Profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

solve_jeweler_problem()
