
import gurobipy as gp

# Create a new model
m = gp.Model("woodshop")

# Create variables
x = m.addVar(vtype=gp.GRB.CONTINUOUS, name="dining_tables") # allow fractional tables/desks
y = m.addVar(vtype=gp.GRB.CONTINUOUS, name="desks")

# Set objective
m.setObjective(350 * x + 400 * y, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(2 * x + 3 * y <= 100, "woodworking")
m.addConstr(3 * x + 4 * y <= 75, "nails")
m.addConstr(x + 2 * y <= 80, "varnish")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Dining Tables: {x.x}")
    print(f"Number of Desks: {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

