
from gurobipy import *

# Create a new model
m = Model("Woodshop_Optimization")

# Define the decision variables
x = m.addVar(name="dining_tables", vtype=GRB.CONTINUOUS, lb=0)
y = m.addVar(name="desks", vtype=GRB.CONTINUOUS, lb=0)

# Define the objective function
m.setObjective(350*x + 400*y, GRB.MAXIMIZE)

# Define the constraints
m.addConstr(2*x + 3*y <= 100, name="woodworking_hours")
m.addConstr(3*x + 4*y <= 75, name="nails")
m.addConstr(x + 2*y <= 80, name="varnish")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of dining tables: {x.x}")
    print(f"Number of desks: {y.x}")
    print(f"Maximum profit: ${350*x.x + 400*y.x:.2f}")
else:
    print("No optimal solution found. The model is either infeasible or unbounded.")
