
import gurobi as gp

# Create a new model
model = gp.Model("Woodshop_Optimization")

# Define the decision variables
x = model.addVar(name="dining_tables", lb=0, vtype=gp.GRB.CONTINUOUS)
y = model.addVar(name="desks", lb=0, vtype=gp.GRB.CONTINUOUS)

# Define the objective function
model.setObjective(350 * x + 400 * y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(2 * x + 3 * y <= 100, name="woodworking_constraint")
model.addConstr(3 * x + 4 * y <= 75, name="nails_constraint")
model.addConstr(x + 2 * y <= 80, name="varnish_constraint")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found. Profit: ${model.objVal:.2f}")
    print(f"Dining tables to make: {x.varValue:.2f}")
    print(f"Desks to make: {y.varValue:.2f}")
else:
    print("No optimal solution found.")
