
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("tea_and_pancakes")

# Create variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="green_tea") # Pitchers of green tea
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="pancakes") # Batches of pancakes

# Set objective function
m.setObjective(2.5 * x + 10 * y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(0.7 * x + 1.2 * y <= 8, "joy_time")
m.addConstr(0.3 * x + 0.6 * y <= 5, "willa_time")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Green tea pitchers: {x.x:.2f}")
    print(f"Pancake batches: {y.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

