
from gurobipy import *

# Create a new model
m = Model("Tea_and_Pancakes")

# Define the decision variables
x = m.addVar(name="pitchers_of_tea", lb=0)
y = m.addVar(name="batches_of_pancakes", lb=0)

# Set the objective function
m.setObjective(2.5*x + 10*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(0.7*x + 1.2*y <= 8, name="Joy_time_constraint")
m.addConstr(0.3*x + 0.6*y <= 5, name="Willa_time_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Pitchers of tea: {x.x}")
    print(f"Batches of pancakes: {y.x}")
    print(f"Total profit: ${2.5*x.x + 10*y.x:.2f}")
else:
    print("No optimal solution found")
