
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(name="green_tea", lb=0, ub=gurobi.GRB.INFINITY)
    y = model.addVar(name="pancakes", lb=0, ub=gurobi.GRB.INFINITY)

    # Objective function: Maximize profit
    model.setObjective(2.5 * x + 10 * y, gurobi.GRB.MAXIMIZE)

    # Joy's time constraint
    model.addConstr(0.7 * x + 1.2 * y <= 8, name="joy_time_constraint")

    # Willa's time constraint
    model.addConstr(0.3 * x + 0.6 * y <= 5, name="willa_time_constraint")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print(f"Optimal profit: ${model.objVal:.2f}")
        print(f"Pitchers of green tea: {x.varValue:.2f}")
        print(f"Batches of pancakes: {y.varValue:.2f}")
    else:
        print("The model is infeasible.")

solve_optimization_problem()
