
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("CarProduction")

# Create decision variables
y1 = model.addVar(vtype=GRB.CONTINUOUS, name="y1")  # Hybrid cars
y2 = model.addVar(vtype=GRB.CONTINUOUS, name="y2")  # Electric cars

# Set objective function
model.setObjective(4500 * y1 + 5500 * y2, GRB.MAXIMIZE)

# Add constraints
model.addConstr(y1 <= 9, "demand_hybrid")
model.addConstr(y2 <= 5, "demand_electric")
model.addConstr(y1 + y2 <= 10, "total_production")
model.addConstr(y1 >= 0, "nonneg_y1")  # Though CONTINUOUS implies this.
model.addConstr(y2 >= 0, "nonneg_y2")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${model.objVal:.2f}")
    print(f"Number of hybrid cars to produce: {y1.x:.2f}")
    print(f"Number of electric cars to produce: {y2.x:.2f}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

