
from gurobipy import *

# Create a new model
m = Model("Eta_Auto_Profit_Optimization")

# Define variables
y1 = m.addVar(lb=0, name="hybrid_models")  # Number of hybrid models
y2 = m.addVar(lb=0, name="electric_models")  # Number of electric models

# Set the objective function: Maximize profit
m.setObjective(4500*y1 + 5500*y2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(y1 <= 9, "hybrid_demand")
m.addConstr(y2 <= 5, "electric_demand")
m.addConstr(y1 + y2 <= 10, "total_production")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hybrid models: {y1.x}")
    print(f"Electric models: {y2.x}")
    print(f"Total profit: ${4500*y1.x + 5500*y2.x}")
else:
    print("No optimal solution found")
