
import gurobi

def solve_eta_auto_problem():
    model = gurobi.Model()

    y1 = model.addVar(lb=0, ub=9, name="hybrid_models")
    y2 = model.addVar(lb=0, ub=5, name="electric_models")

    model.setObjective(4500*y1 + 5500*y2, gurobi.GRB.MAXIMIZE)

    model.addConstr(y1 <= 9, name="hybrid_demand_constraint")
    model.addConstr(y2 <= 5, name="electric_demand_constraint")
    model.addConstr(y1 + y2 <= 10, name="total_production_constraint")

    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal number of hybrid models: {y1.varValue}")
        print(f"Optimal number of electric models: {y2.varValue}")
        print(f"Maximum profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_eta_auto_problem()
