
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("CE_Chemicals_Production")

# Create decision variables
x = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="adhesives") # Packages of adhesives
y = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="plasticizers") # Packages of plasticizers

# Set the objective function
model.setObjective(8.5*x + 11.5*y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(6*x + 8*y <= 450, "automatic_device")
model.addConstr(5*x + 4*y <= 450, "human_operated_device")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Revenue: ${model.objVal:.2f}")
    print(f"Number of Adhesive Packages: {x.x:.2f}")
    print(f"Number of Plasticizer Packages: {y.x:.2f}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

