
from gurobipy import *

# Create a model
m = Model("CE_Chemicals")

# Define the decision variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="adhesives")
y = m.addVar(vtype=GRB.CONTINUOUS, name="plasticizers")

# Objective function: Maximize revenue
m.setObjective(8.5*x + 11.5*y, GRB.MAXIMIZE)

# Constraints
m.addConstr(6*x + 8*y <= 450, "automatic_device")
m.addConstr(5*x + 4*y <= 450, "human_operated_device")

# Non-negativity constraints are implicitly handled by the variable type

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Adhesives: {x.x}")
    print(f"Plasticizers: {y.x}")
    print(f"Maximum Revenue: ${8.5*x.x + 11.5*y.x:.2f}")
else:
    print("No optimal solution found")
