
import gurobi

def solve_production_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x = model.addVar(name="adhesives", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    y = model.addVar(name="plasticizers", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Set up the objective function
    model.setObjective(8.5 * x + 11.5 * y, gurobi.GRB.MAXIMIZE)

    # Add the constraints
    model.addConstr(6 * x + 8 * y <= 450, name="automatic_device_constraint")
    model.addConstr(5 * x + 4 * y <= 450, name="human_operated_device_constraint")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x = {x.varValue}, y = {y.varValue}")
        print(f"Maximum revenue: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_production_problem()
