
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("shoe_profit")

# Create variables
x = m.addVar(lb=0, vtype=GRB.INTEGER, name="sneakers") # Number of sneakers
y = m.addVar(lb=0, vtype=GRB.INTEGER, name="boots")   # Number of boots

# Set objective function
m.setObjective(50*x + 80*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 50, "demand")
m.addConstr(150*x + 200*y <= 8750, "budget")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of sneakers to buy: {x.x}")
    print(f"Number of boots to buy: {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

