
from gurobipy import *

# Create a new model
m = Model("George_Shoes_Problem")

# Define the variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="sneakers")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="boots")

# Set the objective function
m.setObjective(50*x + 80*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 50, "demand_limit")
m.addConstr(150*x + 200*y <= 8750, "budget_limit")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: Buy {x.x} sneakers and {y.x} boots.")
    print(f"Maximum profit: ${50*x.x + 80*y.x}")
else:
    print("No optimal solution found.")

