
import gurobi

# Create a new model
m = gurobi.Model()

# Define the decision variables
s = m.addVar(lb=0, ub=50, name="sneakers")
b = m.addVar(lb=0, ub=50, name="boots")

# Define the objective function
m.setObjective(50 * s + 80 * b, gurobi.GRB.MAXIMIZE)

# Add the budget constraint
m.addConstr(150 * s + 200 * b <= 8750, name="budget")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print(f"Optimal solution: sneakers = {s.varValue}, boots = {b.varValue}")
    print(f"Maximum profit: ${50 * s.varValue + 80 * b.varValue}")
else:
    print("No optimal solution found")
