
import gurobipy as gp

# Create a new model
m = gp.Model("cookie_production")

# Create variables
x = m.addVar(vtype=gp.GRB.CONTINUOUS, name="chocolate_chip")
y = m.addVar(vtype=gp.GRB.CONTINUOUS, name="oatmeal")

# Set objective
m.setObjective(12*x + 15*y, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*x + 8*y <= 1000, "ingredient_gathering")
m.addConstr(20*x + 15*y <= 1200, "mixing")
m.addConstr(50*x + 30*y <= 3000, "baking")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: {m.objVal}")
    print(f"Chocolate Chip Cookies: {x.x}")
    print(f"Oatmeal Cookies: {y.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

