
from gurobipy import *

# Create a model
m = Model("Cookie_Production")

# Define decision variables
x = m.addVar(name="chocolate_chip_batches", vtype=GRB.INTEGER, lb=0)
y = m.addVar(name="oatmeal_batches", vtype=GRB.INTEGER, lb=0)

# Set objective function
m.setObjective(12*x + 15*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*x + 8*y <= 1000, name="gather_ingredients")
m.addConstr(20*x + 15*y <= 1200, name="mixing")
m.addConstr(50*x + 30*y <= 3000, name="baking")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: {x.varName} = {x.x}, {y.varName} = {y.x}")
    print(f"Maximum profit: ${12*x.x + 15*y.x:.2f}")
else:
    print("No optimal solution found")
