
import gurobi

# Create a new model
model = gurobi.Model()

# Define the decision variables
x = model.addVar(name="chocolate_chip", lb=0, ub=gurobi.GRB.INFINITY)
y = model.addVar(name="oatmeal", lb=0, ub=gurobi.GRB.INFINITY)

# Define the objective function
model.setObjective(12 * x + 15 * y, gurobi.GRB.MAXIMIZE)

# Define the constraints
model.addConstr(10 * x + 8 * y <= 1000, name="gathering_ingredients")
model.addConstr(20 * x + 15 * y <= 1200, name="mixing")
model.addConstr(50 * x + 30 * y <= 3000, name="baking")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print(f"Optimal solution: x = {x.varValue}, y = {y.varValue}")
    print(f"Maximum profit: ${model.objVal:.2f}")
else:
    print("No optimal solution found")
