
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("medication_mix")

# Create variables
x = m.addVar(lb=0, name="medication_A")
y = m.addVar(lb=0, name="medication_B")

# Set objective function
m.setObjective(1*x + 2*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(1*x + 3*y >= 20, "cough_relief")
m.addConstr(2*x + 1*y >= 25, "pain_relief")
m.addConstr(3*x + 2*y >= 30, "fever_relief")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal cost: ${m.objVal:.2f}")
    print(f"Medication A: {x.x:.2f} units")
    print(f"Medication B: {y.x:.2f} units")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

