
from gurobipy import *

# Create a new model
m = Model("Medication_Mix")

# Define the decision variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="medication_A", lb=0)
y = m.addVar(vtype=GRB.CONTINUOUS, name="medication_B", lb=0)

# Set the objective function
m.setObjective(1*x + 2*y, GRB.MINIMIZE)

# Add the constraints
m.addConstr(1*x + 3*y >= 20, "cough_relief")
m.addConstr(2*x + 1*y >= 25, "pain_relief")
m.addConstr(3*x + 2*y >= 30, "fever_relief")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Medication A: {x.x}")
    print(f"Medication B: {y.x}")
    print(f"Total Cost: {m.objVal}")
else:
    print("No optimal solution found")
