
import gurobi

def solve_medication_mixture_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the decision variables
    x = model.addVar(lb=0, name="medication_A")
    y = model.addVar(lb=0, name="medication_B")

    # Define the objective function
    model.setObjective(x + 2*y, gurobi.GRB.MINIMIZE)

    # Define the constraints
    model.addConstr(x + 3*y >= 20, name="cough_relief")
    model.addConstr(2*x + y >= 25, name="pain_relief")
    model.addConstr(3*x + 2*y >= 30, name="fever_relief")

    # Optimize the model
    model.optimize()

    # Check if the model is infeasible
    if model.status == gurobi.GRB.Status.INFEASIBLE:
        print("The problem is infeasible.")
        return

    # Print the solution
    print(f"Medication A: {x.varValue}")
    print(f"Medication B: {y.varValue}")
    print(f"Cost: {model.objVal}")

# Run the function
solve_medication_mixture_problem()
