
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("JacketProduction")

# Create decision variables
w = m.addVar(lb=0, vtype=GRB.INTEGER, name="winter_jackets") # Integer number of winter jackets
r = m.addVar(lb=0, vtype=GRB.INTEGER, name="rain_jackets")   # Integer number of rain jackets

# Set objective function
m.setObjective(50*r - 5*w, GRB.MAXIMIZE)

# Add constraints
m.addConstr(w <= 60, "winter_capacity")
m.addConstr(r <= 70, "rain_capacity")
m.addConstr(w >= 30, "winter_demand")
m.addConstr(r >= 35, "rain_demand")
m.addConstr(w + r >= 80, "total_production")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Produce {w.x} winter jackets daily")
    print(f"Produce {r.x} rain jackets daily")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

