
from gurobipy import *

# Create a new model
m = Model("Jacket_Production")

# Define variables
W = m.addVar(lb=30, ub=60, vtype=GRB.INTEGER, name="Winter_Jackets")
R = m.addVar(lb=35, ub=70, vtype=GRB.INTEGER, name="Rain_Jackets")

# Objective function: Maximize profit
m.setObjective(-5*W + 50*R, GRB.MAXIMIZE)

# Constraint: Total jackets made must be at least 80
m.addConstr(W + R >= 80, "Total_Jackets_Constraint")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution: Winter Jackets = {W.x}, Rain Jackets = {R.x}")
    print(f"Maximum Profit: {-5*W.x + 50*R.x}")
else:
    print("No optimal solution found")
