
import gurobi

def solve_jacket_production():
    # Create a new model
    model = gurobi.Model()

    # Define decision variables
    W = model.addVar(lb=30, ub=60, name="Winter_Jackets")  # At least 30, at most 60
    R = model.addVar(lb=35, ub=70, name="Rain_Jackets")  # At least 35, at most 70

    # Objective function: Maximize 50R - 5W
    model.setObjective(50*R - 5*W, gurobi.GRB.MAXIMIZE)

    # Constraint: W + R >= 80
    model.addConstr(W + R >= 80, name="Total_Jackets")

    # Solve the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found.")
        print(f"Winter Jackets: {W.varValue}")
        print(f"Rain Jackets: {R.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_jacket_production()
