
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("investment_optimization")

# Create decision variables
x = m.addVar(lb=0, name="healthcare_investment")
y = m.addVar(lb=0, name="energy_investment")

# Set objective function
m.setObjective(0.04 * x + 0.08 * y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 500000, "total_investment")
m.addConstr(x >= 0.60 * 500000, "min_healthcare")
m.addConstr(y <= 0.35 * 500000, "max_energy")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal investment in healthcare: ${x.x}")
    print(f"Optimal investment in energy: ${y.x}")
    print(f"Maximum return: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

