
from gurobipy import *

# Create a new model
m = Model("Investment_Optimization")

# Define the decision variables
x = m.addVar(lb=0, name="Healthcare_Investment")
y = m.addVar(lb=0, name="Energy_Sector_Investment")

# Define the objective function
m.setObjective(0.04*x + 0.08*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 500000, "Total_Investment")
m.addConstr(x >= 0.6 * (x + y), "Healthcare_Minimum")
m.addConstr(y <= 0.35 * (x + y), "Energy_Sector_Maximum")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Healthcare Investment: {x.x}")
    print(f"Energy Sector Investment: {y.x}")
    print(f"Total Return: {0.04*x.x + 0.08*y.x}")
else:
    print("No optimal solution found")
