
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    H = model.addVar(name="Healthcare", lb=0)  # Investment in healthcare
    E = model.addVar(name="Energy", lb=0)     # Investment in energy

    # Objective: Maximize return on investment
    model.setObjective(0.04 * H + 0.08 * E, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(H + E <= 500000, name="Total_Investment")
    model.addConstr(H >= 0.6 * 500000, name="Healthcare_Min")
    model.addConstr(E <= 0.35 * 500000, name="Energy_Max")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal investment in Healthcare: ${H.varValue:.2f}")
        print(f"Optimal investment in Energy: ${E.varValue:.2f}")
        print(f"Max Return: ${0.04 * H.varValue + 0.08 * E.varValue:.2f}")
    else:
        print("The model is infeasible.")

solve_investment_problem()
