
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("cleaning_optimization")

# Create variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="x") # houses
y = m.addVar(vtype=GRB.CONTINUOUS, name="y") # apartments

# Set objective
m.setObjective(300*x + 250*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x + y <= 600, "sweeping_constraint")
m.addConstr(2*x + 1.5*y <= 700, "mopping_constraint")
m.addConstr(x >= 0, "x_nonnegativity")
m.addConstr(y >= 0, "y_nonnegativity")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of houses to clean: {x.x}")
    print(f"Number of apartments to clean: {y.x}")
    print(f"Maximum profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}.")

