
from gurobipy import *

# Create a model
m = Model("Cleaning_Company_Optimization")

# Define decision variables
H = m.addVar(vtype=GRB.INTEGER, name="houses")
A = m.addVar(vtype=GRB.INTEGER, name="apartments")

# Objective function: Maximize profit
m.setObjective(300*H + 250*A, GRB.MAXIMIZE)

# Constraints
m.addConstr(2*H + A <= 600, "sweeping_time")
m.addConstr(2*H + 1.5*A <= 700, "mopping_time")

# Solve the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Houses: {H.x}")
    print(f"Apartments: {A.x}")
    print(f"Maximum Profit: ${300*H.x + 250*A.x}")
else:
    print("No optimal solution found")

