
import gurobi

def cleaning_company_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the decision variables
    H = model.addVar(lb=0, name="Houses")
    A = model.addVar(lb=0, name="Apartments")

    # Define the objective function
    model.setObjective(300 * H + 250 * A, gurobi.GRB.MAXIMIZE)

    # Define the constraints
    model.addConstr(2 * H + A <= 600, name="Sweeping_Time")
    model.addConstr(2 * H + 1.5 * A <= 700, name="Mopping_Time")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: Houses = {H.varValue}, Apartments = {A.varValue}")
        print(f"Maximum profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found")

# Run the model
cleaning_company_problem()
