
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("Furniture_Production")

# Create decision variables
x = model.addVar(vtype=GRB.INTEGER, name="dining_tables") # Number of dining tables
y = model.addVar(vtype=GRB.INTEGER, name="coffee_tables") # Number of coffee tables


# Set objective function: Maximize profit
model.setObjective(200*x + 100*y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(x + y <= 200, "demand_constraint") # Demand constraint
model.addConstr(250*x + 150*y <= 20000, "budget_constraint") # Budget constraint
model.addConstr(x >= 0, "non_negativity_x") # Non-negativity constraint for x
model.addConstr(y >= 0, "non_negativity_y") # Non-negativity constraint for y

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Dining Tables (x): {x.x}")
    print(f"Number of Coffee Tables (y): {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

