
from gurobipy import *

# Create a model
m = Model("Furniture_Production")

# Define the decision variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="dining_tables")
y = m.addVar(vtype=GRB.CONTINUOUS, name="coffee_tables")

# Set the objective function to maximize profit
m.setObjective(200*x + 100*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 200, "demand_constraint")
m.addConstr(250*x + 150*y <= 20000, "budget_constraint")
m.addConstr(x >= 0, "non_negativity_x")
m.addConstr(y >= 0, "non_negitivity_y")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of dining tables: {x.x}")
    print(f"Number of coffee tables: {y.x}")
    print(f"Maximum profit: ${200*x.x + 100*y.x:.2f}")
else:
    print("No optimal solution found.")
