
import gurobi

def solve_table_production():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    D = model.addVar(name="Dining_Table", lb=0, vtype=gurobi.GRB.INTEGER)
    C = model.addVar(name="Coffee_Table", lb=0, vtype=gurobi.GRB.INTEGER)

    # Objective function: Maximize profit
    model.setObjective(200 * D + 100 * C, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(D + C <= 200, name="Demand_Constraint")
    model.addConstr(250 * D + 150 * C <= 20000, name="Budget_Constraint")

    # Optimize model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal production: Dining tables = {D.varValue}, Coffee tables = {C.varValue}")
        print(f"Maximum profit: ${model.objVal}")
    else:
        print("No optimal solution found.")

if __name__ == "__main__":
    solve_table_production()
