
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("ScooterBikeProduction")

# Create variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="scooters")  # Number of scooters
y = m.addVar(vtype=GRB.CONTINUOUS, name="bikes")  # Number of bikes

# Set objective function
m.setObjective(100*x + 50*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x + 4*y <= 10, "grinder_constraint")
m.addConstr(3*x + 3*y <= 10, "polisher_constraint")
m.addConstr(x >= 0, "scooters_nonnegative")  # Ensure non-negative production
m.addConstr(y >= 0, "bikes_nonnegative")  # Ensure non-negative production


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"  Scooters: {x.x}")
    print(f"  Bikes: {y.x}")
    print(f"  Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

