
from gurobipy import *

# Create a new model
m = Model("Production_Plan")

# Define the decision variables
S = m.addVar(vtype=GRB.CONTINUOUS, name="scooters", lb=0)
B = m.addVar(vtype=GRB.CONTINUOUS, name="bikes", lb=0)

# Set the objective function
m.setObjective(100*S + 50*B, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*S + 4*B <= 10, "grinder_time")
m.addConstr(S + B <= 10/3, "polisher_time")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Scooters: {S.x}")
    print(f"Bikes: {B.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found")
