
import gurobipy as gp

# Create a new model
model = gp.Model("Bolts_and_Nuts")

# Define variables
S = model.addVar(name="Scooters", lb=0, vtype=gp.GRB.CONTINUOUS)
B = model.addVar(name="Bikes", lb=0, vtype=gp.GRB.CONTINUOUS)

# Objective function: Maximize profit
model.setObjective(100 * S + 50 * B, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(2 * S + 4 * B <= 10, name="Grinder_Constraint")
model.addConstr(3 * S + 3 * B <= 10, name="Polisher_Constraint")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: Scooters = {S.varValue}, Bikes = {B.varValue}")
    print(f"Maximum profit: ${model.objVal:.2f}")
else:
    print("No optimal solution found")
